import { TestBed, inject } from '@angular/core/testing';
import { MockBackend, MockConnection } from '@angular/http/testing';
import { Http, BaseRequestOptions, Response, ResponseOptions, RequestMethod } from '@angular/http';

import { ErrorService } from './error.service';

describe('ErrorService', function () {
  let service: ErrorService;
  let backend: MockBackend;

  beforeEach(function () {

    TestBed.configureTestingModule({
      providers: [
        ErrorService,
        MockBackend,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions);
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    });

  });

  beforeEach(inject([ErrorService, MockBackend], function (ErrorService, mockBackend) {
    service = ErrorService;
    backend = mockBackend;
  }));


  it('should create', function (done) {

    backend.connections.subscribe(function (connection: MockConnection) {

      let options = new ResponseOptions({
        body: {
          'errors': [
            {
              'errorCode': 'HTTP 777',
              'errorMessageUser': 'You are very lucky',
              'errorMessageTechnical': 'Lucky Sevens'
            }
          ],
          'contacts': [
            {
              'application': 'eBilling',
              'contact': {
                'name': 'Edward Billings',
                'email': PII               '
              }
            }
          ]
        }

      });
      connection.mockRespond(new Response(options));
    });

    service.setErrorCode('777',  'stack trace: 0192108 error at 801298312. Would you like to play a game?')
    //.subscribe(function(response) {
    //     expect(response).to.be.an('object');
    //     expect(response.messageUser).toEqual('You are very lucky');
    //     expect(response.contactName).toEqual('Edward Billings');
    //     },
    //     function(e) {
    //       console.log(' ERROR:'+e);
    //     }
    //)

    expect(service).toEqual(jasmine.any(Object));

    done();
  });

  afterEach(function () {
    TestBed.resetTestingModule();
  });



});
